;;; -*- Mode:Common-Lisp; Package:USER; Base:10; Fonts:(CPTFONT CPTFONTB) -*-
;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.

;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151

;;; Copyright (C) 1985-1990 Texas Instruments Incorporated. All rights reserved.
;	** (c) Copyright 1980 Massachusetts Institute of Technology **


1; This file contains the lisp-side rpc client example,
; HOOKS, that* 1corresponds to the mac-side rpc server
; example, HOOKS, in the* 1folder* 1microexp:macsys:
; rpc-examples:hooks: The example provides a simple* 1four
; function calculator server on the mac-side, and an
; lisp-side client to* 1demonstrate RPC. * 1This* 1file* 1also* 
;1 demonstrates how* 1to* 1launch and kill the mac-side *
;1 rpc server* 1from* 1lisp.
;
; This demonstration was built and tested under the following 
; configuration:
;
;    Finder 6.1, System 6.03, MPW 3.01
;    TBServer 6.3.01 and 7.3.01
;    microExplorer 6.0 with latest patches
;
;
; Note: Before using this lisp file you must use MPW 3.1 to *
;1 build* 1the* 1application HOOKS, which must exist in the folder
; MICROEXP:MACSYS:RPC-EXAMPLES:HOOKS:*
;
;
1;To run this example execute the* 1following* 1steps in the order
;specified.
;
;       build the applications HOOKS with MPW 3.1
;       meta-x compile buffer in zmacs
;       (launch-my-server) in lisp listener
;
;
; Have the lisp client call the mac server using a sample
; call such as one of the following:
;
;       (calc '+ 100 225)
;       (calc '- 100 225)
;       (calc '* 100 225)
;       (calc '/ 100 225)*


(DEFCONSTANT  *hooks-program-number*     #x20118699)
(DEFCONSTANT  *hooks-version-number*              1)
(DEFCONSTANT  *hooks-procedure-number*            1)


1; We need to pass CALLRPC three arguments, so we have to define *
;1 a* 1filter (structure) because we can only pass one argument.*
(defstruct mystruct
  (operator 0   :type integer)
  (operand1 0.0 :type single-float) 
  (operand2 0.0 :type single-float))


1; We must also define a "serializing" function that knows*
;1 how to encode our filter into the universal xdr language.*
(defun xdr-mystruct (stream obj)
  (rpc:default-and-resolve obj mystruct make-mystruct)
  (send stream :xdr-integer
	(locf (mystruct-operator obj)))   ; operator
  (send stream :xdr-float
	(locf (mystruct-operand1 obj)))   ; operand 1
  (send stream :xdr-float
	(locf (mystruct-operand2 obj))))  ; operand 2


(defvar *mystruct* (make-mystruct))


1; An Alist of operator symbol to integer representation.*
(defconstant operations '((+ . 0) (- . 1) (* . 2) (/ . 3)))


(Defun calc (operator operand1 operand2)
  1"An rpc calculator server.  Syntax is as follows:

    (calc '+ 100 225)
    (calc '- 100 225)
    (calc '* 100 225)
    (calc '/ 100 225)"*

  (unless (assoc operator operations)
    (ferror "invalid operator" "~%Error in operator~a" operator))
  ;1;setup the callrpc IN argument with the correct three values*
  (setf (mystruct-operator *mystruct*) (cdr (assoc operator operations)))
  (setf (mystruct-operand1 *mystruct*) (coerce operand1 'single-float))
  (setf (mystruct-operand2 *mystruct*) (coerce operand2 'single-float))
  ;1;call the calculator procedure running on the mac.*
  (CALLRPC 'mac
	   *hooks-program-number*
	   *hooks-version-number*
	   *hooks-procedure-number*
	   'xdr-mystruct
	   *mystruct*
	   :xdr-float)
  )


1; This form will create a hooks flavor that can talk to the mac
; application* 1over a dedicated micronet channel. * 1It allows you to
; startup the application* 1from lisp or from the mac.  Of course, *
;1 it could also be used as a tbserver to make toolbox calls.*

(tb:define-mac-application hooks nil
	       (:server-name "hooks"
		:lisp-function 'hooks-loop
		:directory ("microexp:macsys:rpc-examples:hooks:")))


(defvar *myserver* nil)

1; This function will startup the mac application from lisp.*
(defun launch-my-server ()
  1"Launch the hooks server and allocate to it a micronet channel."*
  (setf *myserver*
	(tb:launch-mac-application 'hooks)))


1; This function will shutdown the mac application from lisp.
; It can also be shutdown on the mac by selecting Quit 
; from the application's file menu.*

(defun quit-my-server ()
  1"Shutdown the hooks server and deallocate its micronet channel."*
  (when *myserver*
    (send *myserver* :kill-server)
    (send *myserver* :kill)
    (setf *myserver* nil)))


1; Most tbserver applications are written using the lisp toolbox
; interface and have a lisp top-level main-event-loop. * 1Although
; HOOKS* 1is written in C and executes on the mac side, we still need
; a dummy* 1top-level loop for the associated lisp process. * 1This is
; what the* 1function HOOKS-LOOP provides. * 1When HOOKS starts up,
; HOOKS-LOOP will run* 1in an loop basically doing nothing. * 1When HOOKS
; is quit, the lisp* 1associated structures will be deallocated and
; the process killed.*


(defvar *token* t)

;1he never needs to run so give him a low priority.*
;1setting *token* to nil would also quit the server.*

(defun hooks-loop()
  (setf (send si:current-process :priority) -5)	       
  (with-lock (*token* :whostate "just sleep")
  ()
  ))

